import matplotlib.pyplot as plt
import seaborn as sns
import os
from sklearn.preprocessing import LabelEncoder
from sklearn.model_selection import train_test_split
from sklearn.metrics import classification_report, confusion_matrix
from sklearn.linear_model import LogisticRegression
from sklearn.metrics import accuracy_score
from sklearn.preprocessing import StandardScaler
from sklearn.cluster import KMeans
from sklearn.metrics import silhouette_score
import numpy as np
from scipy import stats
import sys
sys.path.append(sys.argv[1])

import pandas as pd
import pickle
from decision_company import read_csv_file, convert_to_datetime

# Load the dataset
atp_tennis = read_csv_file(os.path.join(sys.argv[1], 'atp_tennis.csv'))

# Convert the 'Date' column to datetime format
atp_tennis['Date'] = convert_to_datetime(atp_tennis['Date'])

print(atp_tennis['Date'])
# pickle.dump(atp_tennis['Date'],open("./ref_result/atp_tennis_Date.pkl","wb"))

import pandas as pd
import pickle
from decision_company import read_csv_file, get_max

# Load the dataset

# Find the last date in the dataset
last_date = get_max(atp_tennis['Date'])

print(last_date)
# pickle.dump(last_date,open("./ref_result/last_date.pkl","wb"))

import pandas as pd
import pickle
from decision_company import read_csv_file, create_date_offset, filter_by_date

# Load the dataset

# Filter the dataset to only include matches from the last five years
five_years_ago = last_date - create_date_offset(years=5)
recent_matches = filter_by_date(atp_tennis, 'Date', five_years_ago)

print(recent_matches)
# pickle.dump(recent_matches,open("./ref_result/recent_matches.pkl","wb"))

